// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Virtual Machine priority. </summary>
    public readonly partial struct MachineLearningVmPriority : IEquatable<MachineLearningVmPriority>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MachineLearningVmPriority"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MachineLearningVmPriority(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DedicatedValue = "Dedicated";
        private const string LowPriorityValue = "LowPriority";

        /// <summary> Dedicated. </summary>
        public static MachineLearningVmPriority Dedicated { get; } = new MachineLearningVmPriority(DedicatedValue);
        /// <summary> LowPriority. </summary>
        public static MachineLearningVmPriority LowPriority { get; } = new MachineLearningVmPriority(LowPriorityValue);
        /// <summary> Determines if two <see cref="MachineLearningVmPriority"/> values are the same. </summary>
        public static bool operator ==(MachineLearningVmPriority left, MachineLearningVmPriority right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MachineLearningVmPriority"/> values are not the same. </summary>
        public static bool operator !=(MachineLearningVmPriority left, MachineLearningVmPriority right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MachineLearningVmPriority"/>. </summary>
        public static implicit operator MachineLearningVmPriority(string value) => new MachineLearningVmPriority(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MachineLearningVmPriority other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MachineLearningVmPriority other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
