// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Net;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The MachineLearningVirtualMachineProperties. </summary>
    public partial class MachineLearningVirtualMachineProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MachineLearningVirtualMachineProperties"/>. </summary>
        public MachineLearningVirtualMachineProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningVirtualMachineProperties"/>. </summary>
        /// <param name="virtualMachineSize"> Virtual Machine size. </param>
        /// <param name="sshPort"> Port open for ssh connections. </param>
        /// <param name="notebookServerPort"> Notebook server port open for ssh connections. </param>
        /// <param name="address"> Public IP address of the virtual machine. </param>
        /// <param name="administratorAccount"> Admin credentials for virtual machine. </param>
        /// <param name="isNotebookInstanceCompute"> Indicates whether this compute will be used for running notebooks. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MachineLearningVirtualMachineProperties(string virtualMachineSize, int? sshPort, int? notebookServerPort, IPAddress address, MachineLearningVmSshCredentials administratorAccount, bool? isNotebookInstanceCompute, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            VirtualMachineSize = virtualMachineSize;
            SshPort = sshPort;
            NotebookServerPort = notebookServerPort;
            Address = address;
            AdministratorAccount = administratorAccount;
            IsNotebookInstanceCompute = isNotebookInstanceCompute;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Virtual Machine size. </summary>
        [WirePath("virtualMachineSize")]
        public string VirtualMachineSize { get; set; }
        /// <summary> Port open for ssh connections. </summary>
        [WirePath("sshPort")]
        public int? SshPort { get; set; }
        /// <summary> Notebook server port open for ssh connections. </summary>
        [WirePath("notebookServerPort")]
        public int? NotebookServerPort { get; set; }
        /// <summary> Public IP address of the virtual machine. </summary>
        [WirePath("address")]
        public IPAddress Address { get; set; }
        /// <summary> Admin credentials for virtual machine. </summary>
        [WirePath("administratorAccount")]
        public MachineLearningVmSshCredentials AdministratorAccount { get; set; }
        /// <summary> Indicates whether this compute will be used for running notebooks. </summary>
        [WirePath("isNotebookInstanceCompute")]
        public bool? IsNotebookInstanceCompute { get; set; }
    }
}
