// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Net;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.MachineLearning.Models
{
    public partial class MachineLearningVirtualMachineProperties : IUtf8JsonSerializable, IJsonModel<MachineLearningVirtualMachineProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<MachineLearningVirtualMachineProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<MachineLearningVirtualMachineProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MachineLearningVirtualMachineProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MachineLearningVirtualMachineProperties)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(VirtualMachineSize))
            {
                writer.WritePropertyName("virtualMachineSize"u8);
                writer.WriteStringValue(VirtualMachineSize);
            }
            if (Optional.IsDefined(SshPort))
            {
                writer.WritePropertyName("sshPort"u8);
                writer.WriteNumberValue(SshPort.Value);
            }
            if (Optional.IsDefined(NotebookServerPort))
            {
                writer.WritePropertyName("notebookServerPort"u8);
                writer.WriteNumberValue(NotebookServerPort.Value);
            }
            if (Optional.IsDefined(Address))
            {
                writer.WritePropertyName("address"u8);
                writer.WriteStringValue(Address.ToString());
            }
            if (Optional.IsDefined(AdministratorAccount))
            {
                if (AdministratorAccount != null)
                {
                    writer.WritePropertyName("administratorAccount"u8);
                    writer.WriteObjectValue(AdministratorAccount, options);
                }
                else
                {
                    writer.WriteNull("administratorAccount");
                }
            }
            if (Optional.IsDefined(IsNotebookInstanceCompute))
            {
                writer.WritePropertyName("isNotebookInstanceCompute"u8);
                writer.WriteBooleanValue(IsNotebookInstanceCompute.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        MachineLearningVirtualMachineProperties IJsonModel<MachineLearningVirtualMachineProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MachineLearningVirtualMachineProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MachineLearningVirtualMachineProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeMachineLearningVirtualMachineProperties(document.RootElement, options);
        }

        internal static MachineLearningVirtualMachineProperties DeserializeMachineLearningVirtualMachineProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string virtualMachineSize = default;
            int? sshPort = default;
            int? notebookServerPort = default;
            IPAddress address = default;
            MachineLearningVmSshCredentials administratorAccount = default;
            bool? isNotebookInstanceCompute = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("virtualMachineSize"u8))
                {
                    virtualMachineSize = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("sshPort"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    sshPort = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("notebookServerPort"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    notebookServerPort = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("address"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    address = IPAddress.Parse(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("administratorAccount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        administratorAccount = null;
                        continue;
                    }
                    administratorAccount = MachineLearningVmSshCredentials.DeserializeMachineLearningVmSshCredentials(property.Value, options);
                    continue;
                }
                if (property.NameEquals("isNotebookInstanceCompute"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isNotebookInstanceCompute = property.Value.GetBoolean();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new MachineLearningVirtualMachineProperties(
                virtualMachineSize,
                sshPort,
                notebookServerPort,
                address,
                administratorAccount,
                isNotebookInstanceCompute,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(VirtualMachineSize), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  virtualMachineSize: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(VirtualMachineSize))
                {
                    builder.Append("  virtualMachineSize: ");
                    if (VirtualMachineSize.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{VirtualMachineSize}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{VirtualMachineSize}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SshPort), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  sshPort: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SshPort))
                {
                    builder.Append("  sshPort: ");
                    builder.AppendLine($"{SshPort.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NotebookServerPort), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  notebookServerPort: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(NotebookServerPort))
                {
                    builder.Append("  notebookServerPort: ");
                    builder.AppendLine($"{NotebookServerPort.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Address), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  address: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Address))
                {
                    builder.Append("  address: ");
                    builder.AppendLine($"'{Address.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AdministratorAccount), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  administratorAccount: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AdministratorAccount))
                {
                    builder.Append("  administratorAccount: ");
                    BicepSerializationHelpers.AppendChildObject(builder, AdministratorAccount, options, 2, false, "  administratorAccount: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsNotebookInstanceCompute), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  isNotebookInstanceCompute: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsNotebookInstanceCompute))
                {
                    builder.Append("  isNotebookInstanceCompute: ");
                    var boolValue = IsNotebookInstanceCompute.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<MachineLearningVirtualMachineProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MachineLearningVirtualMachineProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(MachineLearningVirtualMachineProperties)} does not support writing '{options.Format}' format.");
            }
        }

        MachineLearningVirtualMachineProperties IPersistableModel<MachineLearningVirtualMachineProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MachineLearningVirtualMachineProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeMachineLearningVirtualMachineProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(MachineLearningVirtualMachineProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<MachineLearningVirtualMachineProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
