// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Settings for user account that gets created on each on the nodes of a compute. </summary>
    public partial class MachineLearningUserAccountCredentials
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MachineLearningUserAccountCredentials"/>. </summary>
        /// <param name="adminUserName"> Name of the administrator user account which can be used to SSH to nodes. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="adminUserName"/> is null. </exception>
        public MachineLearningUserAccountCredentials(string adminUserName)
        {
            Argument.AssertNotNull(adminUserName, nameof(adminUserName));

            AdminUserName = adminUserName;
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningUserAccountCredentials"/>. </summary>
        /// <param name="adminUserName"> Name of the administrator user account which can be used to SSH to nodes. </param>
        /// <param name="adminUserSshPublicKey"> SSH public key of the administrator user account. </param>
        /// <param name="adminUserPassword"> Password of the administrator user account. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MachineLearningUserAccountCredentials(string adminUserName, string adminUserSshPublicKey, string adminUserPassword, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AdminUserName = adminUserName;
            AdminUserSshPublicKey = adminUserSshPublicKey;
            AdminUserPassword = adminUserPassword;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningUserAccountCredentials"/> for deserialization. </summary>
        internal MachineLearningUserAccountCredentials()
        {
        }

        /// <summary> Name of the administrator user account which can be used to SSH to nodes. </summary>
        [WirePath("adminUserName")]
        public string AdminUserName { get; set; }
        /// <summary> SSH public key of the administrator user account. </summary>
        [WirePath("adminUserSshPublicKey")]
        public string AdminUserSshPublicKey { get; set; }
        /// <summary> Password of the administrator user account. </summary>
        [WirePath("adminUserPassword")]
        public string AdminUserPassword { get; set; }
    }
}
