// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Configure STL Decomposition of the time-series target column. </summary>
    public readonly partial struct MachineLearningUseStl : IEquatable<MachineLearningUseStl>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MachineLearningUseStl"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MachineLearningUseStl(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string SeasonValue = "Season";
        private const string SeasonTrendValue = "SeasonTrend";

        /// <summary> No stl decomposition. </summary>
        public static MachineLearningUseStl None { get; } = new MachineLearningUseStl(NoneValue);
        /// <summary> Season. </summary>
        public static MachineLearningUseStl Season { get; } = new MachineLearningUseStl(SeasonValue);
        /// <summary> SeasonTrend. </summary>
        public static MachineLearningUseStl SeasonTrend { get; } = new MachineLearningUseStl(SeasonTrendValue);
        /// <summary> Determines if two <see cref="MachineLearningUseStl"/> values are the same. </summary>
        public static bool operator ==(MachineLearningUseStl left, MachineLearningUseStl right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MachineLearningUseStl"/> values are not the same. </summary>
        public static bool operator !=(MachineLearningUseStl left, MachineLearningUseStl right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MachineLearningUseStl"/>. </summary>
        public static implicit operator MachineLearningUseStl(string value) => new MachineLearningUseStl(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MachineLearningUseStl other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MachineLearningUseStl other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
