// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Describes AML Resource Usage. </summary>
    public partial class MachineLearningUsage
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MachineLearningUsage"/>. </summary>
        internal MachineLearningUsage()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningUsage"/>. </summary>
        /// <param name="id"> Specifies the resource ID. </param>
        /// <param name="amlWorkspaceLocation"> Region of the AML workspace in the id. </param>
        /// <param name="usageType"> Specifies the resource type. </param>
        /// <param name="unit"> An enum describing the unit of usage measurement. </param>
        /// <param name="currentValue"> The current usage of the resource. </param>
        /// <param name="limit"> The maximum permitted usage of the resource. </param>
        /// <param name="name"> The name of the type of usage. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MachineLearningUsage(string id, string amlWorkspaceLocation, string usageType, MachineLearningUsageUnit? unit, long? currentValue, long? limit, MachineLearningUsageName name, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            AmlWorkspaceLocation = amlWorkspaceLocation;
            UsageType = usageType;
            Unit = unit;
            CurrentValue = currentValue;
            Limit = limit;
            Name = name;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Specifies the resource ID. </summary>
        [WirePath("id")]
        public string Id { get; }
        /// <summary> Region of the AML workspace in the id. </summary>
        [WirePath("amlWorkspaceLocation")]
        public string AmlWorkspaceLocation { get; }
        /// <summary> Specifies the resource type. </summary>
        [WirePath("type")]
        public string UsageType { get; }
        /// <summary> An enum describing the unit of usage measurement. </summary>
        [WirePath("unit")]
        public MachineLearningUsageUnit? Unit { get; }
        /// <summary> The current usage of the resource. </summary>
        [WirePath("currentValue")]
        public long? CurrentValue { get; }
        /// <summary> The maximum permitted usage of the resource. </summary>
        [WirePath("limit")]
        public long? Limit { get; }
        /// <summary> The name of the type of usage. </summary>
        [WirePath("name")]
        public MachineLearningUsageName Name { get; }
    }
}
