// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The MachineLearningUriFileJobInput. </summary>
    public partial class MachineLearningUriFileJobInput : MachineLearningJobInput
    {
        /// <summary> Initializes a new instance of <see cref="MachineLearningUriFileJobInput"/>. </summary>
        /// <param name="uri"> [Required] Input Asset URI. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="uri"/> is null. </exception>
        public MachineLearningUriFileJobInput(Uri uri)
        {
            Argument.AssertNotNull(uri, nameof(uri));

            Uri = uri;
            JobInputType = JobInputType.UriFile;
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningUriFileJobInput"/>. </summary>
        /// <param name="jobInputType"> [Required] Specifies the type of job. </param>
        /// <param name="description"> Description for the input. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="uri"> [Required] Input Asset URI. </param>
        /// <param name="mode"> Input Asset Delivery Mode. </param>
        internal MachineLearningUriFileJobInput(JobInputType jobInputType, string description, IDictionary<string, BinaryData> serializedAdditionalRawData, Uri uri, MachineLearningInputDeliveryMode? mode) : base(jobInputType, description, serializedAdditionalRawData)
        {
            Uri = uri;
            Mode = mode;
            JobInputType = jobInputType;
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningUriFileJobInput"/> for deserialization. </summary>
        internal MachineLearningUriFileJobInput()
        {
        }

        /// <summary> [Required] Input Asset URI. </summary>
        [WirePath("uri")]
        public Uri Uri { get; set; }
        /// <summary> Input Asset Delivery Mode. </summary>
        [WirePath("mode")]
        public MachineLearningInputDeliveryMode? Mode { get; set; }
    }
}
