// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The unit of time measurement for the specified VM price. Example: OneHour. </summary>
    public readonly partial struct MachineLearningUnitOfMeasure : IEquatable<MachineLearningUnitOfMeasure>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MachineLearningUnitOfMeasure"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MachineLearningUnitOfMeasure(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OneHourValue = "OneHour";

        /// <summary> OneHour. </summary>
        public static MachineLearningUnitOfMeasure OneHour { get; } = new MachineLearningUnitOfMeasure(OneHourValue);
        /// <summary> Determines if two <see cref="MachineLearningUnitOfMeasure"/> values are the same. </summary>
        public static bool operator ==(MachineLearningUnitOfMeasure left, MachineLearningUnitOfMeasure right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MachineLearningUnitOfMeasure"/> values are not the same. </summary>
        public static bool operator !=(MachineLearningUnitOfMeasure left, MachineLearningUnitOfMeasure right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MachineLearningUnitOfMeasure"/>. </summary>
        public static implicit operator MachineLearningUnitOfMeasure(string value) => new MachineLearningUnitOfMeasure(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MachineLearningUnitOfMeasure other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MachineLearningUnitOfMeasure other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
