// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The MachineLearningTritonModelJobInput. </summary>
    public partial class MachineLearningTritonModelJobInput : MachineLearningJobInput
    {
        /// <summary> Initializes a new instance of <see cref="MachineLearningTritonModelJobInput"/>. </summary>
        /// <param name="uri"> [Required] Input Asset URI. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="uri"/> is null. </exception>
        public MachineLearningTritonModelJobInput(Uri uri)
        {
            Argument.AssertNotNull(uri, nameof(uri));

            Uri = uri;
            JobInputType = JobInputType.TritonModel;
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningTritonModelJobInput"/>. </summary>
        /// <param name="jobInputType"> [Required] Specifies the type of job. </param>
        /// <param name="description"> Description for the input. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="uri"> [Required] Input Asset URI. </param>
        /// <param name="mode"> Input Asset Delivery Mode. </param>
        internal MachineLearningTritonModelJobInput(JobInputType jobInputType, string description, IDictionary<string, BinaryData> serializedAdditionalRawData, Uri uri, MachineLearningInputDeliveryMode? mode) : base(jobInputType, description, serializedAdditionalRawData)
        {
            Uri = uri;
            Mode = mode;
            JobInputType = jobInputType;
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningTritonModelJobInput"/> for deserialization. </summary>
        internal MachineLearningTritonModelJobInput()
        {
        }

        /// <summary> [Required] Input Asset URI. </summary>
        [WirePath("uri")]
        public Uri Uri { get; set; }
        /// <summary> Input Asset Delivery Mode. </summary>
        [WirePath("mode")]
        public MachineLearningInputDeliveryMode? Mode { get; set; }
    }
}
