// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The MachineLearningTableJobInput. </summary>
    public partial class MachineLearningTableJobInput : MachineLearningJobInput
    {
        /// <summary> Initializes a new instance of <see cref="MachineLearningTableJobInput"/>. </summary>
        /// <param name="uri"> [Required] Input Asset URI. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="uri"/> is null. </exception>
        public MachineLearningTableJobInput(Uri uri)
        {
            Argument.AssertNotNull(uri, nameof(uri));

            Uri = uri;
            JobInputType = JobInputType.Mltable;
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningTableJobInput"/>. </summary>
        /// <param name="jobInputType"> [Required] Specifies the type of job. </param>
        /// <param name="description"> Description for the input. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="uri"> [Required] Input Asset URI. </param>
        /// <param name="mode"> Input Asset Delivery Mode. </param>
        internal MachineLearningTableJobInput(JobInputType jobInputType, string description, IDictionary<string, BinaryData> serializedAdditionalRawData, Uri uri, MachineLearningInputDeliveryMode? mode) : base(jobInputType, description, serializedAdditionalRawData)
        {
            Uri = uri;
            Mode = mode;
            JobInputType = jobInputType;
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningTableJobInput"/> for deserialization. </summary>
        internal MachineLearningTableJobInput()
        {
        }

        /// <summary> [Required] Input Asset URI. </summary>
        [WirePath("uri")]
        public Uri Uri { get; set; }
        /// <summary> Input Asset Delivery Mode. </summary>
        [WirePath("mode")]
        public MachineLearningInputDeliveryMode? Mode { get; set; }
    }
}
