// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary>
    /// The meta-learner is a model trained on the output of the individual heterogeneous models.
    /// Default meta-learners are LogisticRegression for classification tasks (or LogisticRegressionCV if cross-validation is enabled) and ElasticNet for regression/forecasting tasks (or ElasticNetCV if cross-validation is enabled).
    /// This parameter can be one of the following strings: LogisticRegression, LogisticRegressionCV, LightGBMClassifier, ElasticNet, ElasticNetCV, LightGBMRegressor, or LinearRegression
    /// </summary>
    public readonly partial struct MachineLearningStackMetaLearnerType : IEquatable<MachineLearningStackMetaLearnerType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MachineLearningStackMetaLearnerType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MachineLearningStackMetaLearnerType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string LogisticRegressionValue = "LogisticRegression";
        private const string LogisticRegressionCVValue = "LogisticRegressionCV";
        private const string LightGBMClassifierValue = "LightGBMClassifier";
        private const string ElasticNetValue = "ElasticNet";
        private const string ElasticNetCVValue = "ElasticNetCV";
        private const string LightGBMRegressorValue = "LightGBMRegressor";
        private const string LinearRegressionValue = "LinearRegression";

        /// <summary> None. </summary>
        public static MachineLearningStackMetaLearnerType None { get; } = new MachineLearningStackMetaLearnerType(NoneValue);
        /// <summary> Default meta-learners are LogisticRegression for classification tasks. </summary>
        public static MachineLearningStackMetaLearnerType LogisticRegression { get; } = new MachineLearningStackMetaLearnerType(LogisticRegressionValue);
        /// <summary> Default meta-learners are LogisticRegression for classification task when CV is on. </summary>
        public static MachineLearningStackMetaLearnerType LogisticRegressionCV { get; } = new MachineLearningStackMetaLearnerType(LogisticRegressionCVValue);
        /// <summary> LightGBMClassifier. </summary>
        public static MachineLearningStackMetaLearnerType LightGBMClassifier { get; } = new MachineLearningStackMetaLearnerType(LightGBMClassifierValue);
        /// <summary> Default meta-learners are LogisticRegression for regression task. </summary>
        public static MachineLearningStackMetaLearnerType ElasticNet { get; } = new MachineLearningStackMetaLearnerType(ElasticNetValue);
        /// <summary> Default meta-learners are LogisticRegression for regression task when CV is on. </summary>
        public static MachineLearningStackMetaLearnerType ElasticNetCV { get; } = new MachineLearningStackMetaLearnerType(ElasticNetCVValue);
        /// <summary> LightGBMRegressor. </summary>
        public static MachineLearningStackMetaLearnerType LightGBMRegressor { get; } = new MachineLearningStackMetaLearnerType(LightGBMRegressorValue);
        /// <summary> LinearRegression. </summary>
        public static MachineLearningStackMetaLearnerType LinearRegression { get; } = new MachineLearningStackMetaLearnerType(LinearRegressionValue);
        /// <summary> Determines if two <see cref="MachineLearningStackMetaLearnerType"/> values are the same. </summary>
        public static bool operator ==(MachineLearningStackMetaLearnerType left, MachineLearningStackMetaLearnerType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MachineLearningStackMetaLearnerType"/> values are not the same. </summary>
        public static bool operator !=(MachineLearningStackMetaLearnerType left, MachineLearningStackMetaLearnerType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MachineLearningStackMetaLearnerType"/>. </summary>
        public static implicit operator MachineLearningStackMetaLearnerType(string value) => new MachineLearningStackMetaLearnerType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MachineLearningStackMetaLearnerType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MachineLearningStackMetaLearnerType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
