// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.MachineLearning.Models
{
    public partial class MachineLearningStackEnsembleSettings : IUtf8JsonSerializable, IJsonModel<MachineLearningStackEnsembleSettings>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<MachineLearningStackEnsembleSettings>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<MachineLearningStackEnsembleSettings>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MachineLearningStackEnsembleSettings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MachineLearningStackEnsembleSettings)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(StackMetaLearnerType))
            {
                writer.WritePropertyName("stackMetaLearnerType"u8);
                writer.WriteStringValue(StackMetaLearnerType.Value.ToString());
            }
            if (Optional.IsDefined(StackMetaLearnerTrainPercentage))
            {
                writer.WritePropertyName("stackMetaLearnerTrainPercentage"u8);
                writer.WriteNumberValue(StackMetaLearnerTrainPercentage.Value);
            }
            if (Optional.IsDefined(StackMetaLearnerKWargs))
            {
                if (StackMetaLearnerKWargs != null)
                {
                    writer.WritePropertyName("stackMetaLearnerKWargs"u8);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(StackMetaLearnerKWargs);
#else
                    using (JsonDocument document = JsonDocument.Parse(StackMetaLearnerKWargs))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
                else
                {
                    writer.WriteNull("stackMetaLearnerKWargs");
                }
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        MachineLearningStackEnsembleSettings IJsonModel<MachineLearningStackEnsembleSettings>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MachineLearningStackEnsembleSettings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MachineLearningStackEnsembleSettings)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeMachineLearningStackEnsembleSettings(document.RootElement, options);
        }

        internal static MachineLearningStackEnsembleSettings DeserializeMachineLearningStackEnsembleSettings(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            MachineLearningStackMetaLearnerType? stackMetaLearnerType = default;
            double? stackMetaLearnerTrainPercentage = default;
            BinaryData stackMetaLearnerKWargs = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("stackMetaLearnerType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    stackMetaLearnerType = new MachineLearningStackMetaLearnerType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("stackMetaLearnerTrainPercentage"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    stackMetaLearnerTrainPercentage = property.Value.GetDouble();
                    continue;
                }
                if (property.NameEquals("stackMetaLearnerKWargs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        stackMetaLearnerKWargs = null;
                        continue;
                    }
                    stackMetaLearnerKWargs = BinaryData.FromString(property.Value.GetRawText());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new MachineLearningStackEnsembleSettings(stackMetaLearnerType, stackMetaLearnerTrainPercentage, stackMetaLearnerKWargs, serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(StackMetaLearnerType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  stackMetaLearnerType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(StackMetaLearnerType))
                {
                    builder.Append("  stackMetaLearnerType: ");
                    builder.AppendLine($"'{StackMetaLearnerType.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(StackMetaLearnerTrainPercentage), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  stackMetaLearnerTrainPercentage: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(StackMetaLearnerTrainPercentage))
                {
                    builder.Append("  stackMetaLearnerTrainPercentage: ");
                    builder.AppendLine($"'{StackMetaLearnerTrainPercentage.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(StackMetaLearnerKWargs), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  stackMetaLearnerKWargs: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(StackMetaLearnerKWargs))
                {
                    builder.Append("  stackMetaLearnerKWargs: ");
                    builder.AppendLine($"'{StackMetaLearnerKWargs.ToString()}'");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<MachineLearningStackEnsembleSettings>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MachineLearningStackEnsembleSettings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(MachineLearningStackEnsembleSettings)} does not support writing '{options.Format}' format.");
            }
        }

        MachineLearningStackEnsembleSettings IPersistableModel<MachineLearningStackEnsembleSettings>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MachineLearningStackEnsembleSettings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeMachineLearningStackEnsembleSettings(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(MachineLearningStackEnsembleSettings)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<MachineLearningStackEnsembleSettings>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
