// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on this instance. Enabled - Indicates that the public ssh port is open and accessible according to the VNet/subnet policy if applicable. </summary>
    public readonly partial struct MachineLearningSshPublicAccess : IEquatable<MachineLearningSshPublicAccess>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MachineLearningSshPublicAccess"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MachineLearningSshPublicAccess(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static MachineLearningSshPublicAccess Enabled { get; } = new MachineLearningSshPublicAccess(EnabledValue);
        /// <summary> Disabled. </summary>
        public static MachineLearningSshPublicAccess Disabled { get; } = new MachineLearningSshPublicAccess(DisabledValue);
        /// <summary> Determines if two <see cref="MachineLearningSshPublicAccess"/> values are the same. </summary>
        public static bool operator ==(MachineLearningSshPublicAccess left, MachineLearningSshPublicAccess right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MachineLearningSshPublicAccess"/> values are not the same. </summary>
        public static bool operator !=(MachineLearningSshPublicAccess left, MachineLearningSshPublicAccess right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MachineLearningSshPublicAccess"/>. </summary>
        public static implicit operator MachineLearningSshPublicAccess(string value) => new MachineLearningSshPublicAccess(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MachineLearningSshPublicAccess other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MachineLearningSshPublicAccess other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
