// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.MachineLearning.Models
{
    internal static partial class MachineLearningSkuTierExtensions
    {
        public static string ToSerialString(this MachineLearningSkuTier value) => value switch
        {
            MachineLearningSkuTier.Free => "Free",
            MachineLearningSkuTier.Basic => "Basic",
            MachineLearningSkuTier.Standard => "Standard",
            MachineLearningSkuTier.Premium => "Premium",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown MachineLearningSkuTier value.")
        };

        public static MachineLearningSkuTier ToMachineLearningSkuTier(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Free")) return MachineLearningSkuTier.Free;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Basic")) return MachineLearningSkuTier.Basic;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Standard")) return MachineLearningSkuTier.Standard;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Premium")) return MachineLearningSkuTier.Premium;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown MachineLearningSkuTier value.");
        }
    }
}
