// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Node scaling setting for the compute sku. </summary>
    public readonly partial struct MachineLearningSkuScaleType : IEquatable<MachineLearningSkuScaleType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MachineLearningSkuScaleType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MachineLearningSkuScaleType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AutomaticValue = "Automatic";
        private const string ManualValue = "Manual";
        private const string NoneValue = "None";

        /// <summary> Automatically scales node count. </summary>
        public static MachineLearningSkuScaleType Automatic { get; } = new MachineLearningSkuScaleType(AutomaticValue);
        /// <summary> Node count scaled upon user request. </summary>
        public static MachineLearningSkuScaleType Manual { get; } = new MachineLearningSkuScaleType(ManualValue);
        /// <summary> Fixed set of nodes. </summary>
        public static MachineLearningSkuScaleType None { get; } = new MachineLearningSkuScaleType(NoneValue);
        /// <summary> Determines if two <see cref="MachineLearningSkuScaleType"/> values are the same. </summary>
        public static bool operator ==(MachineLearningSkuScaleType left, MachineLearningSkuScaleType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MachineLearningSkuScaleType"/> values are not the same. </summary>
        public static bool operator !=(MachineLearningSkuScaleType left, MachineLearningSkuScaleType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MachineLearningSkuScaleType"/>. </summary>
        public static implicit operator MachineLearningSkuScaleType(string value) => new MachineLearningSkuScaleType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MachineLearningSkuScaleType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MachineLearningSkuScaleType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
