// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Fulfills ARM Contract requirement to list all available SKUS for a resource. </summary>
    public partial class MachineLearningSkuDetail
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MachineLearningSkuDetail"/>. </summary>
        internal MachineLearningSkuDetail()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningSkuDetail"/>. </summary>
        /// <param name="resourceType"> The resource type name. </param>
        /// <param name="sku"> Gets or sets the Sku. </param>
        /// <param name="capacity"> Gets or sets the Sku Capacity. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MachineLearningSkuDetail(string resourceType, MachineLearningSkuSetting sku, MachineLearningSkuCapacity capacity, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ResourceType = resourceType;
            Sku = sku;
            Capacity = capacity;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The resource type name. </summary>
        [WirePath("resourceType")]
        public string ResourceType { get; }
        /// <summary> Gets or sets the Sku. </summary>
        [WirePath("sku")]
        public MachineLearningSkuSetting Sku { get; }
        /// <summary> Gets or sets the Sku Capacity. </summary>
        [WirePath("capacity")]
        public MachineLearningSkuCapacity Capacity { get; }
    }
}
