// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> SKU capacity information. </summary>
    public partial class MachineLearningSkuCapacity
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MachineLearningSkuCapacity"/>. </summary>
        internal MachineLearningSkuCapacity()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningSkuCapacity"/>. </summary>
        /// <param name="minimum"> Gets or sets the minimum. </param>
        /// <param name="maximum"> Gets or sets the maximum. </param>
        /// <param name="default"> Gets or sets the default capacity. </param>
        /// <param name="scaleType"> Gets or sets the type of the scale. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MachineLearningSkuCapacity(int? minimum, int? maximum, int? @default, MachineLearningSkuScaleType? scaleType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Minimum = minimum;
            Maximum = maximum;
            Default = @default;
            ScaleType = scaleType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets the minimum. </summary>
        [WirePath("minimum")]
        public int? Minimum { get; }
        /// <summary> Gets or sets the maximum. </summary>
        [WirePath("maximum")]
        public int? Maximum { get; }
        /// <summary> Gets or sets the default capacity. </summary>
        [WirePath("default")]
        public int? Default { get; }
        /// <summary> Gets or sets the type of the scale. </summary>
        [WirePath("scaleType")]
        public MachineLearningSkuScaleType? ScaleType { get; }
    }
}
