// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The MachineLearningSharedPrivateLinkResource. </summary>
    public partial class MachineLearningSharedPrivateLinkResource
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MachineLearningSharedPrivateLinkResource"/>. </summary>
        public MachineLearningSharedPrivateLinkResource()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningSharedPrivateLinkResource"/>. </summary>
        /// <param name="name"> Unique name of the private link. </param>
        /// <param name="privateLinkResourceId"> The resource id that private link links to. </param>
        /// <param name="groupId"> The private link resource group id. </param>
        /// <param name="requestMessage"> Request message. </param>
        /// <param name="status"> Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MachineLearningSharedPrivateLinkResource(string name, ResourceIdentifier privateLinkResourceId, string groupId, string requestMessage, MachineLearningPrivateEndpointServiceConnectionStatus? status, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            PrivateLinkResourceId = privateLinkResourceId;
            GroupId = groupId;
            RequestMessage = requestMessage;
            Status = status;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Unique name of the private link. </summary>
        [WirePath("name")]
        public string Name { get; set; }
        /// <summary> The resource id that private link links to. </summary>
        [WirePath("properties.privateLinkResourceId")]
        public ResourceIdentifier PrivateLinkResourceId { get; set; }
        /// <summary> The private link resource group id. </summary>
        [WirePath("properties.groupId")]
        public string GroupId { get; set; }
        /// <summary> Request message. </summary>
        [WirePath("properties.requestMessage")]
        public string RequestMessage { get; set; }
        /// <summary> Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service. </summary>
        [WirePath("properties.status")]
        public MachineLearningPrivateEndpointServiceConnectionStatus? Status { get; set; }
    }
}
