// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The MachineLearningServiceDataAccessAuthIdentity. </summary>
    public readonly partial struct MachineLearningServiceDataAccessAuthIdentity : IEquatable<MachineLearningServiceDataAccessAuthIdentity>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MachineLearningServiceDataAccessAuthIdentity"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MachineLearningServiceDataAccessAuthIdentity(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string WorkspaceSystemAssignedIdentityValue = "WorkspaceSystemAssignedIdentity";
        private const string WorkspaceUserAssignedIdentityValue = "WorkspaceUserAssignedIdentity";

        /// <summary> Do not use any identity for service data access. </summary>
        public static MachineLearningServiceDataAccessAuthIdentity None { get; } = new MachineLearningServiceDataAccessAuthIdentity(NoneValue);
        /// <summary> Use the system assigned managed identity of the Workspace to authenticate service data access. </summary>
        public static MachineLearningServiceDataAccessAuthIdentity WorkspaceSystemAssignedIdentity { get; } = new MachineLearningServiceDataAccessAuthIdentity(WorkspaceSystemAssignedIdentityValue);
        /// <summary> Use the user assigned managed identity of the Workspace to authenticate service data access. </summary>
        public static MachineLearningServiceDataAccessAuthIdentity WorkspaceUserAssignedIdentity { get; } = new MachineLearningServiceDataAccessAuthIdentity(WorkspaceUserAssignedIdentityValue);
        /// <summary> Determines if two <see cref="MachineLearningServiceDataAccessAuthIdentity"/> values are the same. </summary>
        public static bool operator ==(MachineLearningServiceDataAccessAuthIdentity left, MachineLearningServiceDataAccessAuthIdentity right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MachineLearningServiceDataAccessAuthIdentity"/> values are not the same. </summary>
        public static bool operator !=(MachineLearningServiceDataAccessAuthIdentity left, MachineLearningServiceDataAccessAuthIdentity right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MachineLearningServiceDataAccessAuthIdentity"/>. </summary>
        public static implicit operator MachineLearningServiceDataAccessAuthIdentity(string value) => new MachineLearningServiceDataAccessAuthIdentity(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MachineLearningServiceDataAccessAuthIdentity other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MachineLearningServiceDataAccessAuthIdentity other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
