// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Strictly used in update requests. </summary>
    public partial class MachineLearningServerlessEndpointPatch : MachineLearningResourcePatch
    {
        /// <summary> Initializes a new instance of <see cref="MachineLearningServerlessEndpointPatch"/>. </summary>
        public MachineLearningServerlessEndpointPatch()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningServerlessEndpointPatch"/>. </summary>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="sku"> Sku details required for ARM contract for Autoscaling. </param>
        /// <param name="identity"> Managed service identity (system assigned and/or user assigned identities). </param>
        internal MachineLearningServerlessEndpointPatch(IDictionary<string, string> tags, IDictionary<string, BinaryData> serializedAdditionalRawData, MachineLearningSkuPatch sku, MachineLearningPartialManagedServiceIdentity identity) : base(tags, serializedAdditionalRawData)
        {
            Sku = sku;
            Identity = identity;
        }

        /// <summary> Sku details required for ARM contract for Autoscaling. </summary>
        [WirePath("sku")]
        public MachineLearningSkuPatch Sku { get; set; }
        /// <summary> Managed service identity (system assigned and/or user assigned identities). </summary>
        [WirePath("identity")]
        public MachineLearningPartialManagedServiceIdentity Identity { get; set; }
    }
}
