// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.MachineLearning.Models
{
    public partial class MachineLearningScriptsToExecute : IUtf8JsonSerializable, IJsonModel<MachineLearningScriptsToExecute>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<MachineLearningScriptsToExecute>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<MachineLearningScriptsToExecute>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MachineLearningScriptsToExecute>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MachineLearningScriptsToExecute)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(StartupScript))
            {
                writer.WritePropertyName("startupScript"u8);
                writer.WriteObjectValue(StartupScript, options);
            }
            if (Optional.IsDefined(CreationScript))
            {
                writer.WritePropertyName("creationScript"u8);
                writer.WriteObjectValue(CreationScript, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        MachineLearningScriptsToExecute IJsonModel<MachineLearningScriptsToExecute>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MachineLearningScriptsToExecute>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MachineLearningScriptsToExecute)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeMachineLearningScriptsToExecute(document.RootElement, options);
        }

        internal static MachineLearningScriptsToExecute DeserializeMachineLearningScriptsToExecute(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            MachineLearningScriptReference startupScript = default;
            MachineLearningScriptReference creationScript = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("startupScript"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    startupScript = MachineLearningScriptReference.DeserializeMachineLearningScriptReference(property.Value, options);
                    continue;
                }
                if (property.NameEquals("creationScript"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    creationScript = MachineLearningScriptReference.DeserializeMachineLearningScriptReference(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new MachineLearningScriptsToExecute(startupScript, creationScript, serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(StartupScript), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  startupScript: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(StartupScript))
                {
                    builder.Append("  startupScript: ");
                    BicepSerializationHelpers.AppendChildObject(builder, StartupScript, options, 2, false, "  startupScript: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CreationScript), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  creationScript: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CreationScript))
                {
                    builder.Append("  creationScript: ");
                    BicepSerializationHelpers.AppendChildObject(builder, CreationScript, options, 2, false, "  creationScript: ");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<MachineLearningScriptsToExecute>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MachineLearningScriptsToExecute>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(MachineLearningScriptsToExecute)} does not support writing '{options.Format}' format.");
            }
        }

        MachineLearningScriptsToExecute IPersistableModel<MachineLearningScriptsToExecute>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MachineLearningScriptsToExecute>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeMachineLearningScriptsToExecute(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(MachineLearningScriptsToExecute)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<MachineLearningScriptsToExecute>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
