// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The MachineLearningScheduleProvisioningStatus. </summary>
    public readonly partial struct MachineLearningScheduleProvisioningStatus : IEquatable<MachineLearningScheduleProvisioningStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MachineLearningScheduleProvisioningStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MachineLearningScheduleProvisioningStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string DeletingValue = "Deleting";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";

        /// <summary> Creating. </summary>
        public static MachineLearningScheduleProvisioningStatus Creating { get; } = new MachineLearningScheduleProvisioningStatus(CreatingValue);
        /// <summary> Updating. </summary>
        public static MachineLearningScheduleProvisioningStatus Updating { get; } = new MachineLearningScheduleProvisioningStatus(UpdatingValue);
        /// <summary> Deleting. </summary>
        public static MachineLearningScheduleProvisioningStatus Deleting { get; } = new MachineLearningScheduleProvisioningStatus(DeletingValue);
        /// <summary> Succeeded. </summary>
        public static MachineLearningScheduleProvisioningStatus Succeeded { get; } = new MachineLearningScheduleProvisioningStatus(SucceededValue);
        /// <summary> Failed. </summary>
        public static MachineLearningScheduleProvisioningStatus Failed { get; } = new MachineLearningScheduleProvisioningStatus(FailedValue);
        /// <summary> Canceled. </summary>
        public static MachineLearningScheduleProvisioningStatus Canceled { get; } = new MachineLearningScheduleProvisioningStatus(CanceledValue);
        /// <summary> Determines if two <see cref="MachineLearningScheduleProvisioningStatus"/> values are the same. </summary>
        public static bool operator ==(MachineLearningScheduleProvisioningStatus left, MachineLearningScheduleProvisioningStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MachineLearningScheduleProvisioningStatus"/> values are not the same. </summary>
        public static bool operator !=(MachineLearningScheduleProvisioningStatus left, MachineLearningScheduleProvisioningStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MachineLearningScheduleProvisioningStatus"/>. </summary>
        public static implicit operator MachineLearningScheduleProvisioningStatus(string value) => new MachineLearningScheduleProvisioningStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MachineLearningScheduleProvisioningStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MachineLearningScheduleProvisioningStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
