// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The current deployment state of schedule. </summary>
    public readonly partial struct MachineLearningScheduleProvisioningState : IEquatable<MachineLearningScheduleProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MachineLearningScheduleProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MachineLearningScheduleProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CompletedValue = "Completed";
        private const string ProvisioningValue = "Provisioning";
        private const string FailedValue = "Failed";

        /// <summary> Completed. </summary>
        public static MachineLearningScheduleProvisioningState Completed { get; } = new MachineLearningScheduleProvisioningState(CompletedValue);
        /// <summary> Provisioning. </summary>
        public static MachineLearningScheduleProvisioningState Provisioning { get; } = new MachineLearningScheduleProvisioningState(ProvisioningValue);
        /// <summary> Failed. </summary>
        public static MachineLearningScheduleProvisioningState Failed { get; } = new MachineLearningScheduleProvisioningState(FailedValue);
        /// <summary> Determines if two <see cref="MachineLearningScheduleProvisioningState"/> values are the same. </summary>
        public static bool operator ==(MachineLearningScheduleProvisioningState left, MachineLearningScheduleProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MachineLearningScheduleProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(MachineLearningScheduleProvisioningState left, MachineLearningScheduleProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MachineLearningScheduleProvisioningState"/>. </summary>
        public static implicit operator MachineLearningScheduleProvisioningState(string value) => new MachineLearningScheduleProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MachineLearningScheduleProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MachineLearningScheduleProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
