// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on all nodes of the cluster. Enabled - Indicates that the public ssh port is open on all nodes of the cluster. NotSpecified - Indicates that the public ssh port is closed on all nodes of the cluster if VNet is defined, else is open all public nodes. It can be default only during cluster creation time, after creation it will be either enabled or disabled. </summary>
    public readonly partial struct MachineLearningRemoteLoginPortPublicAccess : IEquatable<MachineLearningRemoteLoginPortPublicAccess>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MachineLearningRemoteLoginPortPublicAccess"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MachineLearningRemoteLoginPortPublicAccess(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";
        private const string NotSpecifiedValue = "NotSpecified";

        /// <summary> Enabled. </summary>
        public static MachineLearningRemoteLoginPortPublicAccess Enabled { get; } = new MachineLearningRemoteLoginPortPublicAccess(EnabledValue);
        /// <summary> Disabled. </summary>
        public static MachineLearningRemoteLoginPortPublicAccess Disabled { get; } = new MachineLearningRemoteLoginPortPublicAccess(DisabledValue);
        /// <summary> NotSpecified. </summary>
        public static MachineLearningRemoteLoginPortPublicAccess NotSpecified { get; } = new MachineLearningRemoteLoginPortPublicAccess(NotSpecifiedValue);
        /// <summary> Determines if two <see cref="MachineLearningRemoteLoginPortPublicAccess"/> values are the same. </summary>
        public static bool operator ==(MachineLearningRemoteLoginPortPublicAccess left, MachineLearningRemoteLoginPortPublicAccess right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MachineLearningRemoteLoginPortPublicAccess"/> values are not the same. </summary>
        public static bool operator !=(MachineLearningRemoteLoginPortPublicAccess left, MachineLearningRemoteLoginPortPublicAccess right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MachineLearningRemoteLoginPortPublicAccess"/>. </summary>
        public static implicit operator MachineLearningRemoteLoginPortPublicAccess(string value) => new MachineLearningRemoteLoginPortPublicAccess(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MachineLearningRemoteLoginPortPublicAccess other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MachineLearningRemoteLoginPortPublicAccess other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
