// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The MachineLearningRecurrenceTrigger. </summary>
    public partial class MachineLearningRecurrenceTrigger : MachineLearningTriggerBase
    {
        /// <summary> Initializes a new instance of <see cref="MachineLearningRecurrenceTrigger"/>. </summary>
        /// <param name="frequency"> [Required] The frequency to trigger schedule. </param>
        /// <param name="interval"> [Required] Specifies schedule interval in conjunction with frequency. </param>
        public MachineLearningRecurrenceTrigger(MachineLearningRecurrenceFrequency frequency, int interval)
        {
            Frequency = frequency;
            Interval = interval;
            TriggerType = TriggerType.Recurrence;
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningRecurrenceTrigger"/>. </summary>
        /// <param name="triggerType"> [Required]. </param>
        /// <param name="endTime">
        /// Specifies end time of schedule in ISO 8601, but without a UTC offset. Refer https://en.wikipedia.org/wiki/ISO_8601.
        /// Recommented format would be "2022-06-01T00:00:01"
        /// If not present, the schedule will run indefinitely
        /// </param>
        /// <param name="startTime"> Specifies start time of schedule in ISO 8601 format, but without a UTC offset. </param>
        /// <param name="timeZone">
        /// Specifies time zone in which the schedule runs.
        /// TimeZone should follow Windows time zone format. Refer: https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="frequency"> [Required] The frequency to trigger schedule. </param>
        /// <param name="interval"> [Required] Specifies schedule interval in conjunction with frequency. </param>
        /// <param name="schedule"> The recurrence schedule. </param>
        internal MachineLearningRecurrenceTrigger(TriggerType triggerType, string endTime, string startTime, string timeZone, IDictionary<string, BinaryData> serializedAdditionalRawData, MachineLearningRecurrenceFrequency frequency, int interval, MachineLearningRecurrenceSchedule schedule) : base(triggerType, endTime, startTime, timeZone, serializedAdditionalRawData)
        {
            Frequency = frequency;
            Interval = interval;
            Schedule = schedule;
            TriggerType = triggerType;
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningRecurrenceTrigger"/> for deserialization. </summary>
        internal MachineLearningRecurrenceTrigger()
        {
        }

        /// <summary> [Required] The frequency to trigger schedule. </summary>
        [WirePath("frequency")]
        public MachineLearningRecurrenceFrequency Frequency { get; set; }
        /// <summary> [Required] Specifies schedule interval in conjunction with frequency. </summary>
        [WirePath("interval")]
        public int Interval { get; set; }
        /// <summary> The recurrence schedule. </summary>
        [WirePath("schedule")]
        public MachineLearningRecurrenceSchedule Schedule { get; set; }
    }
}
