// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> An enum describing the unit of quota measurement. </summary>
    public readonly partial struct MachineLearningQuotaUnit : IEquatable<MachineLearningQuotaUnit>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MachineLearningQuotaUnit"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MachineLearningQuotaUnit(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CountValue = "Count";

        /// <summary> Count. </summary>
        public static MachineLearningQuotaUnit Count { get; } = new MachineLearningQuotaUnit(CountValue);
        /// <summary> Determines if two <see cref="MachineLearningQuotaUnit"/> values are the same. </summary>
        public static bool operator ==(MachineLearningQuotaUnit left, MachineLearningQuotaUnit right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MachineLearningQuotaUnit"/> values are not the same. </summary>
        public static bool operator !=(MachineLearningQuotaUnit left, MachineLearningQuotaUnit right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MachineLearningQuotaUnit"/>. </summary>
        public static implicit operator MachineLearningQuotaUnit(string value) => new MachineLearningQuotaUnit(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MachineLearningQuotaUnit other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MachineLearningQuotaUnit other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
