// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The properties for Quota update or retrieval. </summary>
    public partial class MachineLearningQuotaProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MachineLearningQuotaProperties"/>. </summary>
        public MachineLearningQuotaProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningQuotaProperties"/>. </summary>
        /// <param name="id"> Specifies the resource ID. </param>
        /// <param name="quotaBasePropertiesType"> Specifies the resource type. </param>
        /// <param name="limit"> The maximum permitted quota of the resource. </param>
        /// <param name="unit"> An enum describing the unit of quota measurement. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MachineLearningQuotaProperties(string id, string quotaBasePropertiesType, long? limit, MachineLearningQuotaUnit? unit, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            QuotaBasePropertiesType = quotaBasePropertiesType;
            Limit = limit;
            Unit = unit;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Specifies the resource ID. </summary>
        [WirePath("id")]
        public string Id { get; set; }
        /// <summary> Specifies the resource type. </summary>
        [WirePath("type")]
        public string QuotaBasePropertiesType { get; set; }
        /// <summary> The maximum permitted quota of the resource. </summary>
        [WirePath("limit")]
        public long? Limit { get; set; }
        /// <summary> An enum describing the unit of quota measurement. </summary>
        [WirePath("unit")]
        public MachineLearningQuotaUnit? Unit { get; set; }
    }
}
