// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The current deployment state of workspace resource. The provisioningState is to indicate states for resource provisioning. </summary>
    public readonly partial struct MachineLearningProvisioningState : IEquatable<MachineLearningProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MachineLearningProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MachineLearningProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string UpdatingValue = "Updating";
        private const string CreatingValue = "Creating";
        private const string DeletingValue = "Deleting";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";

        /// <summary> Unknown. </summary>
        public static MachineLearningProvisioningState Unknown { get; } = new MachineLearningProvisioningState(UnknownValue);
        /// <summary> Updating. </summary>
        public static MachineLearningProvisioningState Updating { get; } = new MachineLearningProvisioningState(UpdatingValue);
        /// <summary> Creating. </summary>
        public static MachineLearningProvisioningState Creating { get; } = new MachineLearningProvisioningState(CreatingValue);
        /// <summary> Deleting. </summary>
        public static MachineLearningProvisioningState Deleting { get; } = new MachineLearningProvisioningState(DeletingValue);
        /// <summary> Succeeded. </summary>
        public static MachineLearningProvisioningState Succeeded { get; } = new MachineLearningProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static MachineLearningProvisioningState Failed { get; } = new MachineLearningProvisioningState(FailedValue);
        /// <summary> Canceled. </summary>
        public static MachineLearningProvisioningState Canceled { get; } = new MachineLearningProvisioningState(CanceledValue);
        /// <summary> Determines if two <see cref="MachineLearningProvisioningState"/> values are the same. </summary>
        public static bool operator ==(MachineLearningProvisioningState left, MachineLearningProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MachineLearningProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(MachineLearningProvisioningState left, MachineLearningProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MachineLearningProvisioningState"/>. </summary>
        public static implicit operator MachineLearningProvisioningState(string value) => new MachineLearningProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MachineLearningProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MachineLearningProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
