// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Deployment container liveness/readiness probe configuration. </summary>
    public partial class MachineLearningProbeSettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MachineLearningProbeSettings"/>. </summary>
        public MachineLearningProbeSettings()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningProbeSettings"/>. </summary>
        /// <param name="failureThreshold"> The number of failures to allow before returning an unhealthy status. </param>
        /// <param name="successThreshold"> The number of successful probes before returning a healthy status. </param>
        /// <param name="timeout"> The probe timeout in ISO 8601 format. </param>
        /// <param name="period"> The length of time between probes in ISO 8601 format. </param>
        /// <param name="initialDelay"> The delay before the first probe in ISO 8601 format. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MachineLearningProbeSettings(int? failureThreshold, int? successThreshold, TimeSpan? timeout, TimeSpan? period, TimeSpan? initialDelay, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            FailureThreshold = failureThreshold;
            SuccessThreshold = successThreshold;
            Timeout = timeout;
            Period = period;
            InitialDelay = initialDelay;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The number of failures to allow before returning an unhealthy status. </summary>
        [WirePath("failureThreshold")]
        public int? FailureThreshold { get; set; }
        /// <summary> The number of successful probes before returning a healthy status. </summary>
        [WirePath("successThreshold")]
        public int? SuccessThreshold { get; set; }
        /// <summary> The probe timeout in ISO 8601 format. </summary>
        [WirePath("timeout")]
        public TimeSpan? Timeout { get; set; }
        /// <summary> The length of time between probes in ISO 8601 format. </summary>
        [WirePath("period")]
        public TimeSpan? Period { get; set; }
        /// <summary> The delay before the first probe in ISO 8601 format. </summary>
        [WirePath("initialDelay")]
        public TimeSpan? InitialDelay { get; set; }
    }
}
