// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The current provisioning state. </summary>
    public readonly partial struct MachineLearningPrivateEndpointConnectionProvisioningState : IEquatable<MachineLearningPrivateEndpointConnectionProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MachineLearningPrivateEndpointConnectionProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MachineLearningPrivateEndpointConnectionProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string CreatingValue = "Creating";
        private const string DeletingValue = "Deleting";
        private const string FailedValue = "Failed";

        /// <summary> Succeeded. </summary>
        public static MachineLearningPrivateEndpointConnectionProvisioningState Succeeded { get; } = new MachineLearningPrivateEndpointConnectionProvisioningState(SucceededValue);
        /// <summary> Creating. </summary>
        public static MachineLearningPrivateEndpointConnectionProvisioningState Creating { get; } = new MachineLearningPrivateEndpointConnectionProvisioningState(CreatingValue);
        /// <summary> Deleting. </summary>
        public static MachineLearningPrivateEndpointConnectionProvisioningState Deleting { get; } = new MachineLearningPrivateEndpointConnectionProvisioningState(DeletingValue);
        /// <summary> Failed. </summary>
        public static MachineLearningPrivateEndpointConnectionProvisioningState Failed { get; } = new MachineLearningPrivateEndpointConnectionProvisioningState(FailedValue);
        /// <summary> Determines if two <see cref="MachineLearningPrivateEndpointConnectionProvisioningState"/> values are the same. </summary>
        public static bool operator ==(MachineLearningPrivateEndpointConnectionProvisioningState left, MachineLearningPrivateEndpointConnectionProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MachineLearningPrivateEndpointConnectionProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(MachineLearningPrivateEndpointConnectionProvisioningState left, MachineLearningPrivateEndpointConnectionProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MachineLearningPrivateEndpointConnectionProvisioningState"/>. </summary>
        public static implicit operator MachineLearningPrivateEndpointConnectionProvisioningState(string value) => new MachineLearningPrivateEndpointConnectionProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MachineLearningPrivateEndpointConnectionProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MachineLearningPrivateEndpointConnectionProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
