// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Reference to an asset via its path in a job output. </summary>
    public partial class MachineLearningOutputPathAssetReference : MachineLearningAssetReferenceBase
    {
        /// <summary> Initializes a new instance of <see cref="MachineLearningOutputPathAssetReference"/>. </summary>
        public MachineLearningOutputPathAssetReference()
        {
            ReferenceType = ReferenceType.OutputPath;
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningOutputPathAssetReference"/>. </summary>
        /// <param name="referenceType"> [Required] Specifies the type of asset reference. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="path"> The path of the file/directory in the job output. </param>
        /// <param name="jobId"> ARM resource ID of the job. </param>
        internal MachineLearningOutputPathAssetReference(ReferenceType referenceType, IDictionary<string, BinaryData> serializedAdditionalRawData, string path, ResourceIdentifier jobId) : base(referenceType, serializedAdditionalRawData)
        {
            Path = path;
            JobId = jobId;
            ReferenceType = referenceType;
        }

        /// <summary> The path of the file/directory in the job output. </summary>
        [WirePath("path")]
        public string Path { get; set; }
        /// <summary> ARM resource ID of the job. </summary>
        [WirePath("jobId")]
        public ResourceIdentifier JobId { get; set; }
    }
}
