// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Output data delivery mode enums. </summary>
    public readonly partial struct MachineLearningOutputDeliveryMode : IEquatable<MachineLearningOutputDeliveryMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MachineLearningOutputDeliveryMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MachineLearningOutputDeliveryMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ReadWriteMountValue = "ReadWriteMount";
        private const string UploadValue = "Upload";
        private const string DirectValue = "Direct";

        /// <summary> ReadWriteMount. </summary>
        public static MachineLearningOutputDeliveryMode ReadWriteMount { get; } = new MachineLearningOutputDeliveryMode(ReadWriteMountValue);
        /// <summary> Upload. </summary>
        public static MachineLearningOutputDeliveryMode Upload { get; } = new MachineLearningOutputDeliveryMode(UploadValue);
        /// <summary> Direct. </summary>
        public static MachineLearningOutputDeliveryMode Direct { get; } = new MachineLearningOutputDeliveryMode(DirectValue);
        /// <summary> Determines if two <see cref="MachineLearningOutputDeliveryMode"/> values are the same. </summary>
        public static bool operator ==(MachineLearningOutputDeliveryMode left, MachineLearningOutputDeliveryMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MachineLearningOutputDeliveryMode"/> values are not the same. </summary>
        public static bool operator !=(MachineLearningOutputDeliveryMode left, MachineLearningOutputDeliveryMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MachineLearningOutputDeliveryMode"/>. </summary>
        public static implicit operator MachineLearningOutputDeliveryMode(string value) => new MachineLearningOutputDeliveryMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MachineLearningOutputDeliveryMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MachineLearningOutputDeliveryMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
