// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Trigger of operation. </summary>
    public readonly partial struct MachineLearningOperationTrigger : IEquatable<MachineLearningOperationTrigger>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MachineLearningOperationTrigger"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MachineLearningOperationTrigger(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UserValue = "User";
        private const string ScheduleValue = "Schedule";
        private const string IdleShutdownValue = "IdleShutdown";

        /// <summary> User. </summary>
        public static MachineLearningOperationTrigger User { get; } = new MachineLearningOperationTrigger(UserValue);
        /// <summary> Schedule. </summary>
        public static MachineLearningOperationTrigger Schedule { get; } = new MachineLearningOperationTrigger(ScheduleValue);
        /// <summary> IdleShutdown. </summary>
        public static MachineLearningOperationTrigger IdleShutdown { get; } = new MachineLearningOperationTrigger(IdleShutdownValue);
        /// <summary> Determines if two <see cref="MachineLearningOperationTrigger"/> values are the same. </summary>
        public static bool operator ==(MachineLearningOperationTrigger left, MachineLearningOperationTrigger right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MachineLearningOperationTrigger"/> values are not the same. </summary>
        public static bool operator !=(MachineLearningOperationTrigger left, MachineLearningOperationTrigger right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MachineLearningOperationTrigger"/>. </summary>
        public static implicit operator MachineLearningOperationTrigger(string value) => new MachineLearningOperationTrigger(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MachineLearningOperationTrigger other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MachineLearningOperationTrigger other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
