// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Name of the last operation. </summary>
    public readonly partial struct MachineLearningOperationName : IEquatable<MachineLearningOperationName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MachineLearningOperationName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MachineLearningOperationName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreateValue = "Create";
        private const string StartValue = "Start";
        private const string StopValue = "Stop";
        private const string RestartValue = "Restart";
        private const string ReimageValue = "Reimage";
        private const string DeleteValue = "Delete";

        /// <summary> Create. </summary>
        public static MachineLearningOperationName Create { get; } = new MachineLearningOperationName(CreateValue);
        /// <summary> Start. </summary>
        public static MachineLearningOperationName Start { get; } = new MachineLearningOperationName(StartValue);
        /// <summary> Stop. </summary>
        public static MachineLearningOperationName Stop { get; } = new MachineLearningOperationName(StopValue);
        /// <summary> Restart. </summary>
        public static MachineLearningOperationName Restart { get; } = new MachineLearningOperationName(RestartValue);
        /// <summary> Reimage. </summary>
        public static MachineLearningOperationName Reimage { get; } = new MachineLearningOperationName(ReimageValue);
        /// <summary> Delete. </summary>
        public static MachineLearningOperationName Delete { get; } = new MachineLearningOperationName(DeleteValue);
        /// <summary> Determines if two <see cref="MachineLearningOperationName"/> values are the same. </summary>
        public static bool operator ==(MachineLearningOperationName left, MachineLearningOperationName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MachineLearningOperationName"/> values are not the same. </summary>
        public static bool operator !=(MachineLearningOperationName left, MachineLearningOperationName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MachineLearningOperationName"/>. </summary>
        public static implicit operator MachineLearningOperationName(string value) => new MachineLearningOperationName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MachineLearningOperationName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MachineLearningOperationName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
