// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The type of operating system. </summary>
    public readonly partial struct MachineLearningOperatingSystemType : IEquatable<MachineLearningOperatingSystemType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MachineLearningOperatingSystemType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MachineLearningOperatingSystemType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LinuxValue = "Linux";
        private const string WindowsValue = "Windows";

        /// <summary> Linux. </summary>
        public static MachineLearningOperatingSystemType Linux { get; } = new MachineLearningOperatingSystemType(LinuxValue);
        /// <summary> Windows. </summary>
        public static MachineLearningOperatingSystemType Windows { get; } = new MachineLearningOperatingSystemType(WindowsValue);
        /// <summary> Determines if two <see cref="MachineLearningOperatingSystemType"/> values are the same. </summary>
        public static bool operator ==(MachineLearningOperatingSystemType left, MachineLearningOperatingSystemType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MachineLearningOperatingSystemType"/> values are not the same. </summary>
        public static bool operator !=(MachineLearningOperatingSystemType left, MachineLearningOperatingSystemType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MachineLearningOperatingSystemType"/>. </summary>
        public static implicit operator MachineLearningOperatingSystemType(string value) => new MachineLearningOperatingSystemType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MachineLearningOperatingSystemType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MachineLearningOperatingSystemType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
