// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Strictly used in update requests. </summary>
    public partial class MachineLearningOnlineDeploymentPatch : MachineLearningResourcePatch
    {
        /// <summary> Initializes a new instance of <see cref="MachineLearningOnlineDeploymentPatch"/>. </summary>
        public MachineLearningOnlineDeploymentPatch()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningOnlineDeploymentPatch"/>. </summary>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="sku"> Sku details required for ARM contract for Autoscaling. </param>
        internal MachineLearningOnlineDeploymentPatch(IDictionary<string, string> tags, IDictionary<string, BinaryData> serializedAdditionalRawData, MachineLearningSkuPatch sku) : base(tags, serializedAdditionalRawData)
        {
            Sku = sku;
        }

        /// <summary> Sku details required for ARM contract for Autoscaling. </summary>
        [WirePath("sku")]
        public MachineLearningSkuPatch Sku { get; set; }
    }
}
