// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Optimization objective. </summary>
    public partial class MachineLearningObjective
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MachineLearningObjective"/>. </summary>
        /// <param name="primaryMetric"> [Required] Name of the metric to optimize. </param>
        /// <param name="goal"> [Required] Defines supported metric goals for hyperparameter tuning. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="primaryMetric"/> is null. </exception>
        public MachineLearningObjective(string primaryMetric, MachineLearningGoal goal)
        {
            Argument.AssertNotNull(primaryMetric, nameof(primaryMetric));

            PrimaryMetric = primaryMetric;
            Goal = goal;
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningObjective"/>. </summary>
        /// <param name="primaryMetric"> [Required] Name of the metric to optimize. </param>
        /// <param name="goal"> [Required] Defines supported metric goals for hyperparameter tuning. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MachineLearningObjective(string primaryMetric, MachineLearningGoal goal, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PrimaryMetric = primaryMetric;
            Goal = goal;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningObjective"/> for deserialization. </summary>
        internal MachineLearningObjective()
        {
        }

        /// <summary> [Required] Name of the metric to optimize. </summary>
        [WirePath("primaryMetric")]
        public string PrimaryMetric { get; set; }
        /// <summary> [Required] Defines supported metric goals for hyperparameter tuning. </summary>
        [WirePath("goal")]
        public MachineLearningGoal Goal { get; set; }
    }
}
