// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> State of the compute node. Values are idle, running, preparing, unusable, leaving and preempted. </summary>
    public readonly partial struct MachineLearningNodeState : IEquatable<MachineLearningNodeState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MachineLearningNodeState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MachineLearningNodeState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IdleValue = "idle";
        private const string RunningValue = "running";
        private const string PreparingValue = "preparing";
        private const string UnusableValue = "unusable";
        private const string LeavingValue = "leaving";
        private const string PreemptedValue = "preempted";

        /// <summary> idle. </summary>
        public static MachineLearningNodeState Idle { get; } = new MachineLearningNodeState(IdleValue);
        /// <summary> running. </summary>
        public static MachineLearningNodeState Running { get; } = new MachineLearningNodeState(RunningValue);
        /// <summary> preparing. </summary>
        public static MachineLearningNodeState Preparing { get; } = new MachineLearningNodeState(PreparingValue);
        /// <summary> unusable. </summary>
        public static MachineLearningNodeState Unusable { get; } = new MachineLearningNodeState(UnusableValue);
        /// <summary> leaving. </summary>
        public static MachineLearningNodeState Leaving { get; } = new MachineLearningNodeState(LeavingValue);
        /// <summary> preempted. </summary>
        public static MachineLearningNodeState Preempted { get; } = new MachineLearningNodeState(PreemptedValue);
        /// <summary> Determines if two <see cref="MachineLearningNodeState"/> values are the same. </summary>
        public static bool operator ==(MachineLearningNodeState left, MachineLearningNodeState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MachineLearningNodeState"/> values are not the same. </summary>
        public static bool operator !=(MachineLearningNodeState left, MachineLearningNodeState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MachineLearningNodeState"/>. </summary>
        public static implicit operator MachineLearningNodeState(string value) => new MachineLearningNodeState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MachineLearningNodeState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MachineLearningNodeState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
