// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> network of this container. </summary>
    public readonly partial struct MachineLearningNetwork : IEquatable<MachineLearningNetwork>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MachineLearningNetwork"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MachineLearningNetwork(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BridgeValue = "Bridge";
        private const string HostValue = "Host";

        /// <summary> Bridge. </summary>
        public static MachineLearningNetwork Bridge { get; } = new MachineLearningNetwork(BridgeValue);
        /// <summary> Host. </summary>
        public static MachineLearningNetwork Host { get; } = new MachineLearningNetwork(HostValue);
        /// <summary> Determines if two <see cref="MachineLearningNetwork"/> values are the same. </summary>
        public static bool operator ==(MachineLearningNetwork left, MachineLearningNetwork right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MachineLearningNetwork"/> values are not the same. </summary>
        public static bool operator !=(MachineLearningNetwork left, MachineLearningNetwork right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MachineLearningNetwork"/>. </summary>
        public static implicit operator MachineLearningNetwork(string value) => new MachineLearningNetwork(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MachineLearningNetwork other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MachineLearningNetwork other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
