// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Mount state. </summary>
    public readonly partial struct MachineLearningMountState : IEquatable<MachineLearningMountState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MachineLearningMountState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MachineLearningMountState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MountRequestedValue = "MountRequested";
        private const string MountedValue = "Mounted";
        private const string MountFailedValue = "MountFailed";
        private const string UnmountRequestedValue = "UnmountRequested";
        private const string UnmountFailedValue = "UnmountFailed";
        private const string UnmountedValue = "Unmounted";

        /// <summary> MountRequested. </summary>
        public static MachineLearningMountState MountRequested { get; } = new MachineLearningMountState(MountRequestedValue);
        /// <summary> Mounted. </summary>
        public static MachineLearningMountState Mounted { get; } = new MachineLearningMountState(MountedValue);
        /// <summary> MountFailed. </summary>
        public static MachineLearningMountState MountFailed { get; } = new MachineLearningMountState(MountFailedValue);
        /// <summary> UnmountRequested. </summary>
        public static MachineLearningMountState UnmountRequested { get; } = new MachineLearningMountState(UnmountRequestedValue);
        /// <summary> UnmountFailed. </summary>
        public static MachineLearningMountState UnmountFailed { get; } = new MachineLearningMountState(UnmountFailedValue);
        /// <summary> Unmounted. </summary>
        public static MachineLearningMountState Unmounted { get; } = new MachineLearningMountState(UnmountedValue);
        /// <summary> Determines if two <see cref="MachineLearningMountState"/> values are the same. </summary>
        public static bool operator ==(MachineLearningMountState left, MachineLearningMountState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MachineLearningMountState"/> values are not the same. </summary>
        public static bool operator !=(MachineLearningMountState left, MachineLearningMountState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MachineLearningMountState"/>. </summary>
        public static implicit operator MachineLearningMountState(string value) => new MachineLearningMountState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MachineLearningMountState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MachineLearningMountState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
