// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Mount Action. </summary>
    public readonly partial struct MachineLearningMountAction : IEquatable<MachineLearningMountAction>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MachineLearningMountAction"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MachineLearningMountAction(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MountValue = "Mount";
        private const string UnmountValue = "Unmount";

        /// <summary> Mount. </summary>
        public static MachineLearningMountAction Mount { get; } = new MachineLearningMountAction(MountValue);
        /// <summary> Unmount. </summary>
        public static MachineLearningMountAction Unmount { get; } = new MachineLearningMountAction(UnmountValue);
        /// <summary> Determines if two <see cref="MachineLearningMountAction"/> values are the same. </summary>
        public static bool operator ==(MachineLearningMountAction left, MachineLearningMountAction right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MachineLearningMountAction"/> values are not the same. </summary>
        public static bool operator !=(MachineLearningMountAction left, MachineLearningMountAction right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MachineLearningMountAction"/>. </summary>
        public static implicit operator MachineLearningMountAction(string value) => new MachineLearningMountAction(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MachineLearningMountAction other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MachineLearningMountAction other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
