// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Model asset version details. </summary>
    public partial class MachineLearningModelVersionProperties : MachineLearningAssetBase
    {
        /// <summary> Initializes a new instance of <see cref="MachineLearningModelVersionProperties"/>. </summary>
        public MachineLearningModelVersionProperties()
        {
            Flavors = new ChangeTrackingDictionary<string, MachineLearningFlavorData>();
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningModelVersionProperties"/>. </summary>
        /// <param name="description"> The asset description text. </param>
        /// <param name="tags"> Tag dictionary. Tags can be added, removed, and updated. </param>
        /// <param name="properties"> The asset property dictionary. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="isArchived"> Is the asset archived?. </param>
        /// <param name="isAnonymous"> If the name version are system generated (anonymous registration). </param>
        /// <param name="flavors"> Mapping of model flavors to their properties. </param>
        /// <param name="modelType"> The storage format for this entity. Used for NCD. </param>
        /// <param name="modelUri"> The URI path to the model contents. </param>
        /// <param name="jobName"> Name of the training job which produced this model. </param>
        /// <param name="provisioningState"> Provisioning state for the model version. </param>
        /// <param name="stage"> Stage in the model lifecycle assigned to this model. </param>
        internal MachineLearningModelVersionProperties(string description, IDictionary<string, string> tags, IDictionary<string, string> properties, IDictionary<string, BinaryData> serializedAdditionalRawData, bool? isArchived, bool? isAnonymous, IDictionary<string, MachineLearningFlavorData> flavors, string modelType, Uri modelUri, string jobName, RegistryAssetProvisioningState? provisioningState, string stage) : base(description, tags, properties, serializedAdditionalRawData, isArchived, isAnonymous)
        {
            Flavors = flavors;
            ModelType = modelType;
            ModelUri = modelUri;
            JobName = jobName;
            ProvisioningState = provisioningState;
            Stage = stage;
        }

        /// <summary> Mapping of model flavors to their properties. </summary>
        [WirePath("flavors")]
        public IDictionary<string, MachineLearningFlavorData> Flavors { get; set; }
        /// <summary> The storage format for this entity. Used for NCD. </summary>
        [WirePath("modelType")]
        public string ModelType { get; set; }
        /// <summary> The URI path to the model contents. </summary>
        [WirePath("modelUri")]
        public Uri ModelUri { get; set; }
        /// <summary> Name of the training job which produced this model. </summary>
        [WirePath("jobName")]
        public string JobName { get; set; }
        /// <summary> Provisioning state for the model version. </summary>
        [WirePath("provisioningState")]
        public RegistryAssetProvisioningState? ProvisioningState { get; }
        /// <summary> Stage in the model lifecycle assigned to this model. </summary>
        [WirePath("stage")]
        public string Stage { get; set; }
    }
}
