// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Image model size. </summary>
    public readonly partial struct MachineLearningModelSize : IEquatable<MachineLearningModelSize>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MachineLearningModelSize"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MachineLearningModelSize(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string SmallValue = "Small";
        private const string MediumValue = "Medium";
        private const string LargeValue = "Large";
        private const string ExtraLargeValue = "ExtraLarge";

        /// <summary> No value selected. </summary>
        public static MachineLearningModelSize None { get; } = new MachineLearningModelSize(NoneValue);
        /// <summary> Small size. </summary>
        public static MachineLearningModelSize Small { get; } = new MachineLearningModelSize(SmallValue);
        /// <summary> Medium size. </summary>
        public static MachineLearningModelSize Medium { get; } = new MachineLearningModelSize(MediumValue);
        /// <summary> Large size. </summary>
        public static MachineLearningModelSize Large { get; } = new MachineLearningModelSize(LargeValue);
        /// <summary> Extra large size. </summary>
        public static MachineLearningModelSize ExtraLarge { get; } = new MachineLearningModelSize(ExtraLargeValue);
        /// <summary> Determines if two <see cref="MachineLearningModelSize"/> values are the same. </summary>
        public static bool operator ==(MachineLearningModelSize left, MachineLearningModelSize right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MachineLearningModelSize"/> values are not the same. </summary>
        public static bool operator !=(MachineLearningModelSize left, MachineLearningModelSize right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MachineLearningModelSize"/>. </summary>
        public static implicit operator MachineLearningModelSize(string value) => new MachineLearningModelSize(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MachineLearningModelSize other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MachineLearningModelSize other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
