// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The MachineLearningMarketplaceSubscriptionProperties. </summary>
    public partial class MachineLearningMarketplaceSubscriptionProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MachineLearningMarketplaceSubscriptionProperties"/>. </summary>
        /// <param name="modelId"> [Required] Target Marketplace Model ID to create a Marketplace Subscription for. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="modelId"/> is null. </exception>
        public MachineLearningMarketplaceSubscriptionProperties(string modelId)
        {
            Argument.AssertNotNull(modelId, nameof(modelId));

            ModelId = modelId;
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningMarketplaceSubscriptionProperties"/>. </summary>
        /// <param name="modelId"> [Required] Target Marketplace Model ID to create a Marketplace Subscription for. </param>
        /// <param name="marketplacePlan"> Marketplace Plan associated with the Marketplace Subscription. </param>
        /// <param name="marketplaceSubscriptionStatus"> Current status of the Marketplace Subscription. </param>
        /// <param name="provisioningState"> Provisioning State of the Marketplace Subscription. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MachineLearningMarketplaceSubscriptionProperties(string modelId, MachineLearningMarketplacePlan marketplacePlan, MarketplaceSubscriptionStatus? marketplaceSubscriptionStatus, MarketplaceSubscriptionProvisioningState? provisioningState, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ModelId = modelId;
            MarketplacePlan = marketplacePlan;
            MarketplaceSubscriptionStatus = marketplaceSubscriptionStatus;
            ProvisioningState = provisioningState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningMarketplaceSubscriptionProperties"/> for deserialization. </summary>
        internal MachineLearningMarketplaceSubscriptionProperties()
        {
        }

        /// <summary> [Required] Target Marketplace Model ID to create a Marketplace Subscription for. </summary>
        [WirePath("modelId")]
        public string ModelId { get; set; }
        /// <summary> Marketplace Plan associated with the Marketplace Subscription. </summary>
        [WirePath("marketplacePlan")]
        public MachineLearningMarketplacePlan MarketplacePlan { get; }
        /// <summary> Current status of the Marketplace Subscription. </summary>
        [WirePath("marketplaceSubscriptionStatus")]
        public MarketplaceSubscriptionStatus? MarketplaceSubscriptionStatus { get; }
        /// <summary> Provisioning State of the Marketplace Subscription. </summary>
        [WirePath("provisioningState")]
        public MarketplaceSubscriptionProvisioningState? ProvisioningState { get; }
    }
}
