// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Load Balancer Type. </summary>
    public readonly partial struct MachineLearningLoadBalancerType : IEquatable<MachineLearningLoadBalancerType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MachineLearningLoadBalancerType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MachineLearningLoadBalancerType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PublicIPValue = "PublicIp";
        private const string InternalLoadBalancerValue = "InternalLoadBalancer";

        /// <summary> PublicIp. </summary>
        public static MachineLearningLoadBalancerType PublicIP { get; } = new MachineLearningLoadBalancerType(PublicIPValue);
        /// <summary> InternalLoadBalancer. </summary>
        public static MachineLearningLoadBalancerType InternalLoadBalancer { get; } = new MachineLearningLoadBalancerType(InternalLoadBalancerValue);
        /// <summary> Determines if two <see cref="MachineLearningLoadBalancerType"/> values are the same. </summary>
        public static bool operator ==(MachineLearningLoadBalancerType left, MachineLearningLoadBalancerType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MachineLearningLoadBalancerType"/> values are not the same. </summary>
        public static bool operator !=(MachineLearningLoadBalancerType left, MachineLearningLoadBalancerType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MachineLearningLoadBalancerType"/>. </summary>
        public static implicit operator MachineLearningLoadBalancerType(string value) => new MachineLearningLoadBalancerType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MachineLearningLoadBalancerType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MachineLearningLoadBalancerType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
