// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The status of a job. </summary>
    public readonly partial struct MachineLearningJobStatus : IEquatable<MachineLearningJobStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MachineLearningJobStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MachineLearningJobStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotStartedValue = "NotStarted";
        private const string StartingValue = "Starting";
        private const string ProvisioningValue = "Provisioning";
        private const string PreparingValue = "Preparing";
        private const string QueuedValue = "Queued";
        private const string RunningValue = "Running";
        private const string FinalizingValue = "Finalizing";
        private const string CancelRequestedValue = "CancelRequested";
        private const string CompletedValue = "Completed";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string NotRespondingValue = "NotResponding";
        private const string PausedValue = "Paused";
        private const string UnknownValue = "Unknown";

        /// <summary> Run hasn't started yet. </summary>
        public static MachineLearningJobStatus NotStarted { get; } = new MachineLearningJobStatus(NotStartedValue);
        /// <summary> Run has started. The user has a run ID. </summary>
        public static MachineLearningJobStatus Starting { get; } = new MachineLearningJobStatus(StartingValue);
        /// <summary> (Not used currently) It will be used if ES is creating the compute target. </summary>
        public static MachineLearningJobStatus Provisioning { get; } = new MachineLearningJobStatus(ProvisioningValue);
        /// <summary> The run environment is being prepared. </summary>
        public static MachineLearningJobStatus Preparing { get; } = new MachineLearningJobStatus(PreparingValue);
        /// <summary> The job is queued in the compute target. For example, in BatchAI the job is in queued state, while waiting for all required nodes to be ready. </summary>
        public static MachineLearningJobStatus Queued { get; } = new MachineLearningJobStatus(QueuedValue);
        /// <summary> The job started to run in the compute target. </summary>
        public static MachineLearningJobStatus Running { get; } = new MachineLearningJobStatus(RunningValue);
        /// <summary> Job is completed in the target. It is in output collection state now. </summary>
        public static MachineLearningJobStatus Finalizing { get; } = new MachineLearningJobStatus(FinalizingValue);
        /// <summary> Cancellation has been requested for the job. </summary>
        public static MachineLearningJobStatus CancelRequested { get; } = new MachineLearningJobStatus(CancelRequestedValue);
        /// <summary> Job completed successfully. This reflects that both the job itself and output collection states completed successfully. </summary>
        public static MachineLearningJobStatus Completed { get; } = new MachineLearningJobStatus(CompletedValue);
        /// <summary> Job failed. </summary>
        public static MachineLearningJobStatus Failed { get; } = new MachineLearningJobStatus(FailedValue);
        /// <summary> Following cancellation request, the job is now successfully canceled. </summary>
        public static MachineLearningJobStatus Canceled { get; } = new MachineLearningJobStatus(CanceledValue);
        /// <summary>
        /// When heartbeat is enabled, if the run isn't updating any information to RunHistory then the run goes to NotResponding state.
        /// NotResponding is the only state that is exempt from strict transition orders. A run can go from NotResponding to any of the previous states.
        /// </summary>
        public static MachineLearningJobStatus NotResponding { get; } = new MachineLearningJobStatus(NotRespondingValue);
        /// <summary> The job is paused by users. Some adjustment to labeling jobs can be made only in paused state. </summary>
        public static MachineLearningJobStatus Paused { get; } = new MachineLearningJobStatus(PausedValue);
        /// <summary> Default job status if not mapped to all other statuses. </summary>
        public static MachineLearningJobStatus Unknown { get; } = new MachineLearningJobStatus(UnknownValue);
        /// <summary> Determines if two <see cref="MachineLearningJobStatus"/> values are the same. </summary>
        public static bool operator ==(MachineLearningJobStatus left, MachineLearningJobStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MachineLearningJobStatus"/> values are not the same. </summary>
        public static bool operator !=(MachineLearningJobStatus left, MachineLearningJobStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MachineLearningJobStatus"/>. </summary>
        public static implicit operator MachineLearningJobStatus(string value) => new MachineLearningJobStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MachineLearningJobStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MachineLearningJobStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
