// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Resource requests/limits for this instance type. </summary>
    public partial class MachineLearningInstanceTypeSchemaResources
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MachineLearningInstanceTypeSchemaResources"/>. </summary>
        public MachineLearningInstanceTypeSchemaResources()
        {
            Requests = new ChangeTrackingDictionary<string, string>();
            Limits = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningInstanceTypeSchemaResources"/>. </summary>
        /// <param name="requests"> Resource requests for this instance type. </param>
        /// <param name="limits"> Resource limits for this instance type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MachineLearningInstanceTypeSchemaResources(IDictionary<string, string> requests, IDictionary<string, string> limits, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Requests = requests;
            Limits = limits;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Resource requests for this instance type. </summary>
        [WirePath("requests")]
        public IDictionary<string, string> Requests { get; }
        /// <summary> Resource limits for this instance type. </summary>
        [WirePath("limits")]
        public IDictionary<string, string> Limits { get; }
    }
}
