// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> DTO object representing feature. </summary>
    public partial class MachineLearningFeatureProperties : MachineLearningResourceBase
    {
        /// <summary> Initializes a new instance of <see cref="MachineLearningFeatureProperties"/>. </summary>
        public MachineLearningFeatureProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningFeatureProperties"/>. </summary>
        /// <param name="description"> The asset description text. </param>
        /// <param name="tags"> Tag dictionary. Tags can be added, removed, and updated. </param>
        /// <param name="properties"> The asset property dictionary. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="featureName"> Specifies name. </param>
        /// <param name="dataType"> Specifies type. </param>
        internal MachineLearningFeatureProperties(string description, IDictionary<string, string> tags, IDictionary<string, string> properties, IDictionary<string, BinaryData> serializedAdditionalRawData, string featureName, FeatureDataType? dataType) : base(description, tags, properties, serializedAdditionalRawData)
        {
            FeatureName = featureName;
            DataType = dataType;
        }

        /// <summary> Specifies name. </summary>
        [WirePath("featureName")]
        public string FeatureName { get; set; }
        /// <summary> Specifies type. </summary>
        [WirePath("dataType")]
        public FeatureDataType? DataType { get; set; }
    }
}
