// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Flag for generating lags for the numeric features. </summary>
    public readonly partial struct MachineLearningFeatureLag : IEquatable<MachineLearningFeatureLag>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MachineLearningFeatureLag"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MachineLearningFeatureLag(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string AutoValue = "Auto";

        /// <summary> No feature lags generated. </summary>
        public static MachineLearningFeatureLag None { get; } = new MachineLearningFeatureLag(NoneValue);
        /// <summary> System auto-generates feature lags. </summary>
        public static MachineLearningFeatureLag Auto { get; } = new MachineLearningFeatureLag(AutoValue);
        /// <summary> Determines if two <see cref="MachineLearningFeatureLag"/> values are the same. </summary>
        public static bool operator ==(MachineLearningFeatureLag left, MachineLearningFeatureLag right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MachineLearningFeatureLag"/> values are not the same. </summary>
        public static bool operator !=(MachineLearningFeatureLag left, MachineLearningFeatureLag right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MachineLearningFeatureLag"/>. </summary>
        public static implicit operator MachineLearningFeatureLag(string value) => new MachineLearningFeatureLag(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MachineLearningFeatureLag other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MachineLearningFeatureLag other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
