// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The estimated price info for using a VM of a particular OS type, tier, etc. </summary>
    public partial class MachineLearningEstimatedVmPrice
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MachineLearningEstimatedVmPrice"/>. </summary>
        /// <param name="retailPrice"> The price charged for using the VM. </param>
        /// <param name="osType"> Operating system type used by the VM. </param>
        /// <param name="vmTier"> The type of the VM. </param>
        internal MachineLearningEstimatedVmPrice(double retailPrice, MachineLearningVmPriceOSType osType, MachineLearningVmTier vmTier)
        {
            RetailPrice = retailPrice;
            OSType = osType;
            VmTier = vmTier;
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningEstimatedVmPrice"/>. </summary>
        /// <param name="retailPrice"> The price charged for using the VM. </param>
        /// <param name="osType"> Operating system type used by the VM. </param>
        /// <param name="vmTier"> The type of the VM. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MachineLearningEstimatedVmPrice(double retailPrice, MachineLearningVmPriceOSType osType, MachineLearningVmTier vmTier, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            RetailPrice = retailPrice;
            OSType = osType;
            VmTier = vmTier;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningEstimatedVmPrice"/> for deserialization. </summary>
        internal MachineLearningEstimatedVmPrice()
        {
        }

        /// <summary> The price charged for using the VM. </summary>
        [WirePath("retailPrice")]
        public double RetailPrice { get; }
        /// <summary> Operating system type used by the VM. </summary>
        [WirePath("osType")]
        public MachineLearningVmPriceOSType OSType { get; }
        /// <summary> The type of the VM. </summary>
        [WirePath("vmTier")]
        public MachineLearningVmTier VmTier { get; }
    }
}
